﻿using Microsoft.EntityFrameworkCore;
using StokYonetimSistemi.DataAccess;
using StokYonetimSistemi.Entities;
using System;
using System.Collections.Generic;
using System.Linq;

namespace StokYonetimSistemi.Business
{
    public class UrunManager
    {
        public List<Urun> TumUrunleriGetir()
        {
            using (var context = new StokYonetimDbContext())
            {
                // Sadece AktifMi = true olan ürünleri getir.
                return context.Urunler
                              .Include(u => u.Kategori)
                              .Where(u => u.AktifMi) // <-- BU SATIRI EKLEYİN
                              .ToList();
            }
        }

        public void UrunEkle(Urun urun)
        {
            using (var context = new StokYonetimDbContext())
            {
                if (context.Urunler.Any(u => u.Barkod == urun.Barkod && !string.IsNullOrEmpty(urun.Barkod)))
                {
                    throw new Exception("Bu barkod numarası zaten başka bir ürüne ait!");
                }
                context.Urunler.Add(urun);
                context.SaveChanges();
            }
        }

        // YENİ EKLENEN METOTLAR
        public void UrunGuncelle(Urun urun)
        {
            using (var context = new StokYonetimDbContext())
            {
                // Entity'nin durumunu Modified olarak işaretleyerek güncelleme yapıyoruz.
                context.Entry(urun).State = EntityState.Modified;
                context.SaveChanges();
            }
        }

        public void UrunSil(int id)
        {
            using (var context = new StokYonetimDbContext())
            {
                var silinecekUrun = context.Urunler.Find(id);
                if (silinecekUrun != null)
                {
                    // Ürünü veritabanından silmek yerine,
                    // onu pasif olarak işaretliyoruz.
                    silinecekUrun.AktifMi = false;
                    context.SaveChanges();
                }
            }
        }
    }
}